<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Search Your Ticket')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('action-button'); ?>
    <div class="text-right my-5">
        <a href="<?php echo e(route('faq')); ?>" class="btn-submit"><?php echo e(__('FAQ')); ?></a>
        <a href="<?php echo e(route('home')); ?>" class="btn-submit"><?php echo e(__('Create Ticket')); ?></a>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-lg-5 col-md-7">
        <div class="card bg-secondary border-0 mb-0 mt-6">
            <div class="card-body px-lg-5 py-lg-5 ">
                <div class="text-center text-muted mb-4">
                    <h2 class="mb-3 text-18"><?php echo e(__('Search Your Ticket')); ?></h2>
                </div>
                <form method="post">
                    <?php echo csrf_field(); ?>
                    <?php if(session()->has('info')): ?>
                        <div class="alert alert-danger">
                            <?php echo e(session()->get('info')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session()->has('status')): ?>
                        <div class="alert alert-info">
                            <?php echo e(session()->get('status')); ?>

                        </div>
                    <?php endif; ?>
                    <div class="form-group col-md-12">
                        <label for="ticket_id" class="form-control-label"><?php echo e(__('Ticket Number')); ?></label>
                        <div class="form-icon-user">
                            <span class="prefix-icon"><i class="fas fa-search"></i></span>
                            <input type="number" class="form-control <?php echo e($errors->has('ticket_id') ? 'is-invalid' : ''); ?>" min="0" id="ticket_id" name="ticket_id" placeholder="<?php echo e(__('Enter Ticket Number')); ?>" required="" value="<?php echo e(old('ticket_id')); ?>" autofocus>
                            <div class="invalid-feedback d-block">
                                <?php echo e($errors->first('ticket_id')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-12">
                        <label for="email" class="form-control-label"><?php echo e(__('Email')); ?></label>
                        <div class="form-icon-user">
                            <span class="prefix-icon"><i class="fas fa-envelope"></i></span>
                            <input type="email" class="form-control <?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" id="email" name="email" placeholder="<?php echo e(__('Enter Email')); ?>" required="" value="<?php echo e(old('email')); ?>">
                            <div class="invalid-feedback d-block">
                                <?php echo e($errors->first('email')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-12">
                        <button class="btn btn-rounded btn-submit btn-block"><?php echo e(__('Search')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sigtiesc/soporte.sigties.com/resources/views/search.blade.php ENDPATH**/ ?>