<?php $__env->startSection('page-title'); ?>
<?php echo e(__('Create User')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="post" class="needs-validation" action="<?php echo e(route('admin.users.store')); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Name')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" placeholder="<?php echo e(__('Full name of the user')); ?>" name="name"
                                class="form-control <?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('name')); ?>" autofocus>
                            <div class="invalid-feedback">
                                <?php echo e($errors->first('name')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Email')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="email" placeholder="<?php echo e(__('Email address (should be unique)')); ?>" name="email"
                                class="form-control <?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('email')); ?>">
                            <div class="invalid-feedback">
                                <?php echo e($errors->first('email')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Role')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <select class="form-control select2" name="role">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Password')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="password" name="password" autocomplete="new-password"
                                placeholder="<?php echo e(__('Set an account password')); ?>"
                                class="form-control <?php echo e($errors->has('password') ? ' is-invalid': ''); ?>">
                            <div class="invalid-feedback">
                                <?php echo e($errors->first('password')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Confirm Password')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="password" name="password_confirmation"
                                placeholder="<?php echo e(__('Confirm account password')); ?>" autocomplete="new-password"
                                class="form-control <?php echo e($errors->has('password_confirmation') ? ' is-invalid': ''); ?>">
                            <div class="invalid-feedback">
                                <?php echo e($errors->first('password_confirmation')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Avatar')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <div class="form-group col-lg-12 col-md-12">
                                <label
                                    class="form-control-label"><?php echo e(__('Please upload a valid image file. Size of image should not be more than 2MB.')); ?></label>
                                <div class="choose-file form-group">
                                    <label for="file" class="form-control-label">
                                        <div><?php echo e(__('Choose File Here')); ?></div>
                                        <input type="file"
                                            class="form-control <?php echo e($errors->has('avatar') ? ' is-invalid' : ''); ?>"
                                            name="avatar" id="file" data-filename="avatar_selection">
                                        <div class="invalid-feedback">
                                            <?php echo e($errors->first('avatar')); ?>

                                        </div>
                                    </label>
                                    <p class="avatar_selection"></p>
                                </div>
                            </div>

                            
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"></label>
                        <div class="col-sm-12 col-md-7" id="enabled-button">
                            <button class="btn-submit" id="button-click"><span><?php echo e(__('Add')); ?></span></button>
                        </div>

                        <div class="col-sm-12 col-md-7" id="disabled-button" style="display: none">
                            <button type="button" class="btn-submit">
                                <span>
                                    <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;">
                                        <span class="sr-only">Loading...</span>
                                    </div> &nbsp; <?php echo e(__('Add')); ?>

                                </span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
const button = document.getElementById("button-click");
button.addEventListener("click", (event) => {
    const enabled = document.getElementById("enabled-button");
    enabled.style.display = "none";

    const disabled = document.getElementById("disabled-button");
    disabled.style.display = "block";
})
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/support/resources/views/admin/users/create.blade.php ENDPATH**/ ?>