<?php

namespace App\Traits;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\App;

trait UserTrait
{
    public function getProfilelinkAttribute()
    {
        return route('admin.users.edit', ['user' => $this->id]);
    }

    public function getAvatarlinkAttribute()
    {
        $path = "http://localhost/support/storage";
        if($this->avatar != '' && Storage::exists("/public/" . $this->avatar))
        {
            // $image_path = storage_path() . "/public/" . $this->avatar;
            $image_path = $path . "/public/" . $this->avatar;
        } else {
            // $image_path = storage_path() . "avatar.png";
            $image_path = $path . "avatar.png";
        }
        $image_id = (substr($this->id, -1, 1)) % 5;
        $image_id = $image_id == 0 ? 5 : $image_id;
        return $image_path;
    }

    public function getIsmeAttribute()
    {
        return Auth::check() && (Auth::id() == $this->id);
    }
}
